﻿// Copyright © 2007. Adobe Systems Incorporated. All Rights Reserved.
package fl.motion
{
/**
 * The Tweenables class provides constant values for the names of animation properties used in the Motion and Keyframe classes.  
 * @playerversion Flash 9.0.28.0
 * @langversion 3.0
 * @keyword Tweenables, Copy Motion as ActionScript    
 * @see ../../motionXSD.html Motion XML Elements   
 * @see fl.motion.Motion
 * @see fl.motion.Keyframe
 */
public class Tweenables
{
    /**
     * Constant for the <code>x</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript       
     * @see fl.motion.Keyframe#x
     */
    public static const X:String = 'x';



    /**
     * Constant for the <code>y</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.Keyframe#y
     */
    public static const Y:String = 'y';



    /**
     * Constant for the <code>scaleX</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.Keyframe#scaleX
     */
    public static const SCALE_X:String = 'scaleX';



    /**
     * Constant for the <code>scaleY</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.Keyframe#scaleY
     */
    public static const SCALE_Y:String = 'scaleY';



    /**
     * Constant for the <code>skewX</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.Keyframe#skewX
     */
    public static const SKEW_X:String = 'skewX';



    /**
     * Constant for the <code>skewY</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.Keyframe#skewY
     */
    public static const SKEW_Y:String = 'skewY';



    /**
     * Constant for the <code>rotation</code> property.
     * @playerversion Flash 9.0.28.0
     * @langversion 3.0
     * @keyword Tweenables, Copy Motion as ActionScript      
     * @see fl.motion.Keyframe#rotation
     */
	public static const ROTATION:String = 'rotation';
	   
}
}